<?php
// generate_pdf.php

// Ensure Composer's autoloader is included using a robust path.
require_once __DIR__ . '/vendor/autoload.php';

// Reference the Dompdf namespace for easier access to its classes.
use Dompdf\Dompdf;
use Dompdf\Options;

// Instantiate Dompdf with options.
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
// Allow Dompdf to fetch remote images and CSS. Use with caution.
// Ensure the URLs are trusted. For local file access, paths should be absolute or relative.
$options->set('isRemoteEnabled', true); 
// Consider setting a chroot if you have local assets (images, CSS) referenced in sample.html
// $options->setChroot(__DIR__); // Example: allow access to files in the current directory

$dompdf = new Dompdf($options);

// Load HTML content from 'sample.html'.
$html_file_path = __DIR__ . '/sample.html'; // Assumes sample.html is in the same directory
if (!file_exists($html_file_path)) {
    error_log("Error: sample.html not found at path: " . $html_file_path);
    die("Error: The required HTML file (sample.html) was not found. Please ensure it exists in the script's directory.");
}
$html_content = file_get_contents($html_file_path);
if ($html_content === false) {
    error_log("Error: Could not read sample.html from path: " . $html_file_path);
    die("Error: Could not read sample.html. Please check file permissions and path.");
}

$dompdf->loadHtml($html_content);

// (Optional) Set Paper Size and Orientation.
$dompdf->setPaper('A4', 'portrait');

// Render the HTML as PDF.
$dompdf->render();

// Output the generated PDF to Browser.
// "Attachment" => 1 prompts for download.
// "Attachment" => 0 attempts to stream/display in browser.
$outputFilename = "generated_document_from_sample_" . date('Y-m-d') . ".pdf";
$dompdf->stream($outputFilename, ["Attachment" => 0]);

// Alternatively, to save the PDF to a file on the server:
// $output_pdf_path = __DIR__ . '/saved_document.pdf';
// $pdf_output = $dompdf->output();
// if (file_put_contents($output_pdf_path, $pdf_output) === false) {
//     error_log("Error: Could not save PDF to path: " . $output_pdf_path);
//     die("Error saving PDF file.");
// }
// echo "PDF saved successfully to " . $output_pdf_path;

exit; // Important to prevent any further output
?>
